#pragma once

#include "TunerCtrlDlg.h"

// CTSRecordingDlg dialog

class CTSRecordingDlg : public CDialog
{
	DECLARE_DYNAMIC(CTSRecordingDlg)

public:
	CTSRecordingDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CTSRecordingDlg();

// Dialog Data
	enum { IDD = IDD_TS_RECORDING_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

	afx_msg void OnBnClickedCancel();
	virtual void PostNcDestroy();

	virtual BOOL OnInitDialog();

public:

	void PassRecordingInfo(tRecordingInfo* pRecordingInfo)
	{
		m_pRecordingInfo = pRecordingInfo;
	}

	void PassB2C2MPEG2Adapter(CB2FilterGraphHandler* pB2FilterGraph)
	{
		m_pB2FilterGraph = pB2FilterGraph;
	}

private:
	tRecordingInfo* m_pRecordingInfo;
	CB2FilterGraphHandler		*m_pB2FilterGraph;

	int m_iTimerCounts;

public:
	afx_msg void OnDestroy();

	static UINT __stdcall CTSRecordingDlg::ProcessTransportStreamPacket(WORD wPID, unsigned char* pucTransportPacket);
	static void CTSRecordingDlg::CheckPidContinuityCounter(WORD wPID, BYTE* pucTransportPacket);

	void GenerateTimeStampedFilename( CString* pcsRecordPathName, char* szPath, char* szRootName );

	static int m_iPacketsProcessed;
	static int m_iContinuityErrors;
	static BOOL bInitializeContinuity;
	static BYTE bt[0x1fff];

	CString m_cstrRecordPathName;

public:
	afx_msg void OnTimer(UINT_PTR nIDEvent);
};
